package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCompanyInfoForbiddenAndDisabled;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCompanyInfoForbiddenAndDisabledAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithEnableCompanyInfoForbiddenAndDisabled> {

    @Override
    public Class<CampaignWithEnableCompanyInfoForbiddenAndDisabled> getTypeClass() {
        return CampaignWithEnableCompanyInfoForbiddenAndDisabled.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithEnableCompanyInfoForbiddenAndDisabled> campaigns) {
        campaigns.forEach(campaign -> campaign.setEnableCompanyInfo(false));
    }
}
