package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCompanyInfoForbiddenAndEnabled;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCompanyInfoForbiddenAndEnabledAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithEnableCompanyInfoForbiddenAndEnabled> {
    @Override
    public Class<CampaignWithEnableCompanyInfoForbiddenAndEnabled> getTypeClass() {
        return CampaignWithEnableCompanyInfoForbiddenAndEnabled.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addContainer,
                               List<CampaignWithEnableCompanyInfoForbiddenAndEnabled> campaigns) {
        campaigns.forEach(campaign -> campaign.setEnableCompanyInfo(true));
    }
}
