package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCpcHoldForbidden;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCpcHoldForbiddenAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithEnableCpcHoldForbidden> {

    @Override
    public Class<CampaignWithEnableCpcHoldForbidden> getTypeClass() {
        return CampaignWithEnableCpcHoldForbidden.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithEnableCpcHoldForbidden> campaigns) {
        campaigns.forEach(campaign -> campaign.setEnableCpcHold(false));
    }
}
