package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEshowsSettingsAndStrategy;
import ru.yandex.direct.core.entity.campaign.model.EshowsSettings;
import ru.yandex.direct.core.entity.campaign.model.EshowsVideoType;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEshowsSettingsAndStrategyAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithEshowsSettingsAndStrategy> {

    @Override
    public Class<CampaignWithEshowsSettingsAndStrategy> getTypeClass() {
        return CampaignWithEshowsSettingsAndStrategy.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsAddOperationContainer addContainer,
                                List<CampaignWithEshowsSettingsAndStrategy> models) {
        // Сбрасываем невалидные значения eshowsSettings->videoType в зависимости от стратегии
        models.forEach(campaign -> {
            EshowsSettings eshowsSettings = campaign.getEshowsSettings() != null ?
                    campaign.getEshowsSettings() :
                    new EshowsSettings();
            EshowsVideoType videoType = eshowsSettings.getVideoType();
            StrategyName strategyName = campaign.getStrategy().getStrategyName();
            Boolean isAvgCpvStrategy = strategyName.equals(StrategyName.AUTOBUDGET_AVG_CPV) ||
                    strategyName.equals(StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD);

            if (isAvgCpvStrategy) {
                eshowsSettings.setVideoType(null);
                campaign.setEshowsSettings(eshowsSettings);
            } else if (videoType == null) {
                eshowsSettings.setVideoType(EshowsVideoType.COMPLETES);
                campaign.setEshowsSettings(eshowsSettings);
            }
        });
    }

}
