package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignExperiment;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithExperiments;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.retargeting.model.ExperimentRetargetingConditions;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.feature.FeatureName;

import static ru.yandex.direct.core.entity.retargeting.converter.ExperimentConverter.getExperimentIdsIfNotEmpty;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithExperimentsAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithExperiments> {

    private final RetargetingConditionService retargetingConditionService;
    private final FeatureService featureService;

    @Autowired
    public CampaignWithExperimentsAddOperationSupport(RetargetingConditionService retargetingConditionService,
                                                      FeatureService featureService) {
        this.retargetingConditionService = retargetingConditionService;
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithExperiments> getTypeClass() {
        return CampaignWithExperiments.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsAddOperationContainer addParameters, List<CampaignWithExperiments> campaigns) {
        boolean experimentRetargetingConditionsAutoCreatingEnabledForClientId =
                featureService.isEnabledForClientId(addParameters.getClientId(),
                        FeatureName.EXPERIMENT_RET_CONDITIONS_CREATING_ON_TEXT_CAMPAIGNS_MODIFY_IN_JAVA_FOR_DNA);

        if (experimentRetargetingConditionsAutoCreatingEnabledForClientId) {
            List<CampaignExperiment> campaignExperiments = mapList(campaigns, campaign -> new CampaignExperiment()
                    .withAbSegmentGoalIds(getExperimentIdsIfNotEmpty(campaign.getAbSegmentGoalIds()))
                    .withSectionIds(getExperimentIdsIfNotEmpty(campaign.getSectionIds())));

            List<ExperimentRetargetingConditions> experimentRetargetingConditions =
                    retargetingConditionService.findOrCreateExperimentsRetargetingConditions(
                            addParameters.getClientId(),
                            campaignExperiments,
                            addParameters.getMetrikaClient().getAbSegmentGoals(),
                            null);

            EntryStream.of(campaigns)
                    .forKeyValue((index, campaign) -> updateCampaignWithExperimentRetargetingConditions(campaign,
                            experimentRetargetingConditions.get(index)));
        }

    }

    private void updateCampaignWithExperimentRetargetingConditions(
            CampaignWithExperiments campaign,
            ExperimentRetargetingConditions experimentRetargetingConditions) {

        campaign.setAbSegmentRetargetingConditionId(experimentRetargetingConditions
                .getRetargetingConditionId());

        campaign.setAbSegmentStatisticRetargetingConditionId(experimentRetargetingConditions
                .getStatisticRetargetingConditionId());
    }
}
