package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithExtendedGeoTargetingForbidden;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithExtendedGeoTargetingForbiddenAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithExtendedGeoTargetingForbidden> {

    @Override
    public Class<CampaignWithExtendedGeoTargetingForbidden> getTypeClass() {
        return CampaignWithExtendedGeoTargetingForbidden.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithExtendedGeoTargetingForbidden> campaigns) {
        campaigns.forEach(campaign -> campaign.setHasExtendedGeoTargeting(false));
    }
}
