package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithFixedTimeTargeting;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

import static ru.yandex.direct.libs.timetarget.TimeTargetUtils.defaultTimeTarget;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithFixedTimeTargetingAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithFixedTimeTargeting> {

    @Autowired
    public CampaignWithFixedTimeTargetingAddOperationSupport() {
    }

    @Override
    public Class<CampaignWithFixedTimeTargeting> getTypeClass() {
        return CampaignWithFixedTimeTargeting.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithFixedTimeTargeting> campaigns) {
        campaigns.forEach(campaign -> campaign.setTimeTarget(defaultTimeTarget()));
    }
}
