package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWarnPlaceInterval;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithForbiddenCheckPositionEvent;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithForbiddenCheckPositionEventAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithForbiddenCheckPositionEvent> {
    @Override
    public Class<CampaignWithForbiddenCheckPositionEvent> getTypeClass() {
        return CampaignWithForbiddenCheckPositionEvent.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addContainer,
                               List<CampaignWithForbiddenCheckPositionEvent> models) {
        var forceCheckPositionIntervalEvent = addContainer.getOptions().isForceCheckPositionIntervalEvent();
        var forceEnableCheckPositionEvent = addContainer.getOptions().isForceEnableCheckPositionEvent();
        for (CampaignWithForbiddenCheckPositionEvent c : models) {
            if (!forceCheckPositionIntervalEvent || c.getCheckPositionIntervalEvent() == null) {
                c.withCheckPositionIntervalEvent(CampaignWarnPlaceInterval._60);
            }
            if (!forceEnableCheckPositionEvent || c.getEnableCheckPositionEvent() == null) {
                c.withEnableCheckPositionEvent(false);
            }
        }
    }
}
