package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithForbiddenStrategy;
import ru.yandex.direct.core.entity.campaign.model.CampaignsAutobudget;
import ru.yandex.direct.core.entity.campaign.model.CampaignsPlatform;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStrategyName;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithForbiddenStrategyAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithForbiddenStrategy> {

    public static DbStrategy defaultStrategy() {
        var strategy = new DbStrategy();
        strategy.setStrategyName(StrategyName.DEFAULT_);
        strategy.setAutobudget(CampaignsAutobudget.NO);
        strategy.setPlatform(CampaignsPlatform.BOTH);
        strategy.setStrategyData(new StrategyData()
                .withName(CampaignsStrategyName.default_.getLiteral())
                .withVersion(1L));
        return strategy;
    }

    @Override
    public Class<CampaignWithForbiddenStrategy> getTypeClass() {
        return CampaignWithForbiddenStrategy.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithForbiddenStrategy> campaigns) {
        campaigns.forEach(campaign -> campaign.setStrategy(defaultStrategy()));
    }

}
