package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithGeo;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.regions.GeoTree;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithGeoAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithGeo> {
    private final ClientService clientService;
    private final ClientGeoService clientGeoService;

    @Autowired
    public CampaignWithGeoAddOperationSupport(ClientService clientService, ClientGeoService clientGeoService) {
        this.clientService = clientService;
        this.clientGeoService = clientGeoService;
    }

    @Override
    public Class<CampaignWithGeo> getTypeClass() {
        return CampaignWithGeo.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithGeo> campaigns) {
        // При копировании мы хотим сохранить оригинальное поле geo, от копируемой кампании
        if (addCampaignParametersContainer.isCopy()) {
            return;
        }

        Long geo = clientService.getCountryRegionIdByClientIdStrict(addCampaignParametersContainer.getClientId());
        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(addCampaignParametersContainer.getClientId());
        Set<Integer> geoSet = listToSet(clientGeoService.convertForSave(List.of(geo), geoTree), Long::intValue);
        campaigns.forEach(campaign -> campaign.setGeo(geoSet));
    }

}
