package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoals;
import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal;
import ru.yandex.direct.core.entity.campaign.service.MeaningfulGoalUtils;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;


@Component
@ParametersAreNonnullByDefault
public class CampaignWithMeaningfulGoalsTypesAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithMeaningfulGoals> {
    @Override
    public Class<CampaignWithMeaningfulGoals> getTypeClass() {
        return CampaignWithMeaningfulGoals.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithMeaningfulGoals> campaigns) {
        campaigns.forEach(this::removeDefaultGoals);
    }

    /**
     * Фронт может присылать дефолтную цель(ака Вовлеченные Сессии) без value. Её записывать в базу не следует.
     */
    private void removeDefaultGoals(CampaignWithMeaningfulGoals campaignWithMeaningfulGoals) {
        if (campaignWithMeaningfulGoals.getMeaningfulGoals() == null) {
            return;
        }
        List<MeaningfulGoal> meaningfulGoalsWithoutDefault =
                StreamEx.of(campaignWithMeaningfulGoals.getMeaningfulGoals())
                        .remove(MeaningfulGoalUtils::goalIsDefault)
                        .toList();
        campaignWithMeaningfulGoals.setMeaningfulGoals(meaningfulGoalsWithoutDefault);
    }
}
