package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.type.measurers.BannerWithMeasurersUtils;
import ru.yandex.direct.core.entity.campaign.model.CampaignMeasurer;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeasurers;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMeasurersAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithMeasurers> {
    private final FeatureService featureService;

    public CampaignWithMeasurersAddOperationSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithMeasurers> getTypeClass() {
        return CampaignWithMeasurers.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsAddOperationContainer addParameters,
                                List<CampaignWithMeasurers> campaigns) {
        if(featureService.isEnabledForClientId(addParameters.getClientId(), FeatureName.MOAT_USE_UNSTABLE_SCRIPT)) {
            campaigns.forEach(camp -> fillSystemFields(camp));
        }
    }

    private void fillSystemFields(CampaignWithMeasurers camp) {
        List<CampaignMeasurer> measurers = camp.getMeasurers();
        BannerWithMeasurersUtils.setCampMoatUseUnstableScript(measurers);
    }
}
