package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.apache.commons.collections4.CollectionUtils;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMetrikaCounters;
import ru.yandex.direct.core.entity.campaign.model.MetrikaCounter;
import ru.yandex.direct.core.entity.campaign.repository.CampMetrikaCountersRepository;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.metrika.service.campaigngoals.CommonCampaignCountersService;
import ru.yandex.direct.core.entity.metrikacounter.model.MetrikaCounterWithAdditionalInformation;

import static ru.yandex.direct.core.entity.campaign.converter.CampaignConverter.toMetrikaCounters;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMetrikaCountersAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithMetrikaCounters> {
    private final CampMetrikaCountersRepository campMetrikaCountersRepository;
    private final CommonCampaignCountersService commonCampaignCountersService;

    @Autowired
    public CampaignWithMetrikaCountersAddOperationSupport(CampMetrikaCountersRepository campMetrikaCountersRepository,
                                                          CommonCampaignCountersService commonCampaignCountersService) {
        this.campMetrikaCountersRepository = campMetrikaCountersRepository;
        this.commonCampaignCountersService = commonCampaignCountersService;
    }

    @Override
    public Class<CampaignWithMetrikaCounters> getTypeClass() {
        return CampaignWithMetrikaCounters.class;
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext,
                                                   RestrictedCampaignsAddOperationContainer addModelContainer,
                                                   List<CampaignWithMetrikaCounters> campaigns) {
        var campaignsWithMetrikaCountersToInsert =
                filterList(campaigns, campaign -> CollectionUtils.isNotEmpty(campaign.getMetrikaCounters()));

        if (campaignsWithMetrikaCountersToInsert.isEmpty()) {
            return;
        }

        var counterIdsByCampaignId = listToMap(
                campaignsWithMetrikaCountersToInsert,
                CampaignWithMetrikaCounters::getId,
                campaign -> listToSet(campaign.getMetrikaCounters())
        );

        var availableCounters = commonCampaignCountersService.getRelevantCounters(
                addModelContainer.getClientId(),
                counterIdsByCampaignId,
                addModelContainer.getMetrikaClient().getUsersCountersNumExtendedByCampaignCounterIds(),
                addModelContainer.getMetrikaClient().getCampaignCountersIfNeeded()
        );

        var availableCountersById = StreamEx.of(availableCounters.values())
                .flatCollection(Function.identity())
                .toMap(MetrikaCounterWithAdditionalInformation::getId, Function.identity(), (a, b) -> a);

        Map<Long, List<MetrikaCounter>> countersByCid =
                StreamEx.of(campaignsWithMetrikaCountersToInsert)
                        .mapToEntry(CampaignWithMetrikaCounters::getId,
                                CampaignWithMetrikaCounters::getMetrikaCounters)
                        .mapValues(counters -> toMetrikaCounters(counters, availableCountersById))
                        .toMap();

        campMetrikaCountersRepository.updateMetrikaCounters(dslContext, countersByCid);
    }

}
