package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.service.MinusKeywordPreparingTool;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMinusKeywords;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMinusKeywordsAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithMinusKeywords> {
    private final MinusKeywordPreparingTool minusKeywordPreparingTool;

    @Autowired
    public CampaignWithMinusKeywordsAddOperationSupport(MinusKeywordPreparingTool minusKeywordPreparingTool) {
        this.minusKeywordPreparingTool = minusKeywordPreparingTool;
    }

    @Override
    public Class<CampaignWithMinusKeywords> getTypeClass() {
        return CampaignWithMinusKeywords.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithMinusKeywords> campaigns) {
        campaigns.forEach(campaign -> {
            List<String> minusKeywords = campaign.getMinusKeywords();
            if (minusKeywords != null) {
                campaign.setMinusKeywords(minusKeywordPreparingTool.fullPrepareForSaving(minusKeywords));
            }
        });
    }
}
