package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOfflineStatNoticeEvent;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOfflineStatNoticeEventAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithOfflineStatNoticeEvent> {
    @Override
    public Class<CampaignWithOfflineStatNoticeEvent> getTypeClass() {
        return CampaignWithOfflineStatNoticeEvent.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithOfflineStatNoticeEvent> campaigns) {
        campaigns.forEach(campaign -> CampaignConverter.setFieldIfNull(campaign,
                CampaignWithOfflineStatNoticeEvent.ENABLE_OFFLINE_STAT_NOTICE,
                CampaignConstants.DEFAULT_ENABLE_OFFLINE_STAT_NOTICE));
    }
}
