package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrganizationAndPhone;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOrganizationAndPhoneAddOperationSupport
        extends AbstractCampaignAddOperationSupport<CampaignWithOrganizationAndPhone> {

    @Override
    public Class<CampaignWithOrganizationAndPhone> getTypeClass() {
        return CampaignWithOrganizationAndPhone.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsAddOperationContainer addContainer,
                                List<CampaignWithOrganizationAndPhone> models) {
        // Не добавляем телефон при отсутствии организации
        models.forEach(campaign -> {
            if (campaign.getDefaultChainId() == null && campaign.getDefaultPermalinkId() == null) {
                campaign.setDefaultTrackingPhoneId(null);
            }
        });
    }

}
