package ru.yandex.direct.core.entity.campaign.service.type.add

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.PlacementTypesChangeLogger
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPlacementTypes
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer

@Component
class CampaignWithPlacementTypesAddOperationSupport(
    private val placementTypesChangeLogger: PlacementTypesChangeLogger
) : AbstractCampaignAddOperationSupport<CampaignWithPlacementTypes>() {

    override fun getTypeClass() = CampaignWithPlacementTypes::class.java

    override fun afterExecution(addContainer: RestrictedCampaignsAddOperationContainer, models: List<CampaignWithPlacementTypes>) {
        logPlacementTypesChanges(models, addContainer)
    }

    private fun logPlacementTypesChanges(models: List<CampaignWithPlacementTypes>, addContainer: RestrictedCampaignsAddOperationContainer) {
        models.forEach {
            placementTypesChangeLogger.log(
                addContainer.operatorUid, campaignId = it.id,
                oldState = null,
                newState = it.placementTypes
            )
        }
    }
}
