package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;
import java.util.Optional;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithRefreshingTurbolandingMetrikaGrants;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.AddServicedCampaignInfo;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.turbolanding.service.TurboLandingService;

import static ru.yandex.direct.core.entity.campaign.service.type.add.utils.CampaignAddTypeSupportUtilsKt.getManagerUidWithServicedCampaignIds;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;


@Component
@ParametersAreNonnullByDefault
public class CampaignWithRefreshingTurbolandingMetrikaGrantsAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithRefreshingTurbolandingMetrikaGrants> {

    /**
     * сейчас явно указан тип кампании TEXT, в случае если support будет использоваться для других типов кампаний
     * нужно посчитать managerHasClientCampaigns для всех затрагиваемых типов
     */
    public static final Set<CampaignType> MANAGER_SEARCH_CAMPAIGN_TYPES = Set.of(CampaignType.TEXT);

    private final AddServicedCampaignService addServicedCampaignService;
    private final CampaignRepository campaignRepository;
    private final TurboLandingService turboLandingService;

    @Autowired
    public CampaignWithRefreshingTurbolandingMetrikaGrantsAddOperationSupport(AddServicedCampaignService addServicedCampaignService,
                                                                              CampaignRepository campaignRepository,
                                                                              TurboLandingService turboLandingService) {
        this.addServicedCampaignService = addServicedCampaignService;
        this.campaignRepository = campaignRepository;
        this.turboLandingService = turboLandingService;
    }

    @Override
    public Class<CampaignWithRefreshingTurbolandingMetrikaGrants> getTypeClass() {
        return CampaignWithRefreshingTurbolandingMetrikaGrants.class;
    }

    @Override
    public void afterExecution(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithRefreshingTurbolandingMetrikaGrants> campaigns) {
        List<AddServicedCampaignInfo> servicedInfos =
                addServicedCampaignService.getServicedInfoForNewCampaigns(addCampaignParametersContainer, campaigns);

        var managerWithCampaignIds = getManagerUidWithServicedCampaignIds(servicedInfos, campaigns);
        var managerUid = Optional.ofNullable(managerWithCampaignIds)
                .map(UidWithCampaignIds::getUid)
                .orElse(null);

        if (managerUid != null) {
            var campaignIds = managerWithCampaignIds.getCampaignIds();

            boolean managerHasClientCampaigns = campaignRepository
                    .managerHasClientCampaignsIgnoringCurrentCampaigns(
                            addCampaignParametersContainer.getShard(),
                            addCampaignParametersContainer.getClientId(),
                            managerUid, listToSet(campaignIds), MANAGER_SEARCH_CAMPAIGN_TYPES);

            if (!managerHasClientCampaigns) {
                turboLandingService.refreshTurbolandingMetrikaGrants(addCampaignParametersContainer.getOperatorUid(),
                        addCampaignParametersContainer.getClientId());
            }
        }

    }

}
