package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithTitleSubstitutionForbiddenAndDisabled;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithTitleSubstitutionForbiddenAndDisabledAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithTitleSubstitutionForbiddenAndDisabled> {

    @Override
    public Class<CampaignWithTitleSubstitutionForbiddenAndDisabled> getTypeClass() {
        return CampaignWithTitleSubstitutionForbiddenAndDisabled.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithTitleSubstitutionForbiddenAndDisabled> campaigns) {
        campaigns.forEach(campaign -> campaign.setHasTitleSubstitution(false));
    }
}
