package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithTitleSubstitutionForbiddenAndEnabled;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithTitleSubstitutionForbiddenAndEnabledAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithTitleSubstitutionForbiddenAndEnabled> {
    @Override
    public Class<CampaignWithTitleSubstitutionForbiddenAndEnabled> getTypeClass() {
        return CampaignWithTitleSubstitutionForbiddenAndEnabled.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addContainer,
                               List<CampaignWithTitleSubstitutionForbiddenAndEnabled> campaigns) {
        campaigns.forEach(campaign -> campaign.setHasTitleSubstitution(true));
    }
}
