package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.campaign.model.CpmCampaignWithCustomStrategy;
import ru.yandex.direct.core.entity.campaign.model.DbStrategyBase;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils;
import ru.yandex.direct.core.entity.feature.service.FeatureService;

import static ru.yandex.direct.feature.FeatureName.PACKAGE_STRATEGIES_STAGE_TWO;
import static ru.yandex.direct.utils.CommonUtils.isValidId;

@Component
@ParametersAreNonnullByDefault
public class CpmCampaignWithCustomStrategyAddOperationSupport extends AbstractCampaignAddOperationSupport<CpmCampaignWithCustomStrategy> {

    @Autowired
    public FeatureService featureService;

    @Override
    public Class<CpmCampaignWithCustomStrategy> getTypeClass() {
        return CpmCampaignWithCustomStrategy.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addContainer,
                               List<CpmCampaignWithCustomStrategy> models) {
        boolean isPackageStrategiesStageTwoEnabled =
                featureService.isEnabledForClientId(addContainer.getClientId(), PACKAGE_STRATEGIES_STAGE_TWO);

        LocalDateTime now = LocalDateTime.now();

        StreamEx.of(models)
                .filter(c -> !isCampaignWithPackageStrategyAndStrategyIdIsValid(isPackageStrategiesStageTwoEnabled, c))
                .map(CpmCampaignWithCustomStrategy::getStrategy)
                .map(DbStrategyBase::getStrategyData)
                .filter(CampaignWithStrategyValidationUtils::isStrategyNameForCpmStrategyWithCustomPeriod)
                .forEach(data -> data
                        .withDailyChangeCount(1L)
                        .withLastUpdateTime(now));
    }

    private boolean isCampaignWithPackageStrategyAndStrategyIdIsValid(boolean isPackageStrategiesStageTwoEnabled,
                                                                      CpmCampaignWithCustomStrategy campaign) {
        return isPackageStrategiesStageTwoEnabled
                && campaign instanceof CampaignWithPackageStrategy
                && isValidId(((CampaignWithPackageStrategy) campaign).getStrategyId());
    }
}
