package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.campaign.model.InternalAutobudgetCampaignWithCustomStrategy;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.strategy.model.StrategyWithConversion;

import static ru.yandex.direct.feature.FeatureName.PACKAGE_STRATEGIES_STAGE_TWO;
import static ru.yandex.direct.utils.CommonUtils.isValidId;

@Component
@ParametersAreNonnullByDefault
public class InternalAutobudgetCampaignWithCustomStrategyAddOperationSupport
        extends AbstractCampaignAddOperationSupport<InternalAutobudgetCampaignWithCustomStrategy> {

    @Autowired
    public FeatureService featureService;

    @Override
    public Class<InternalAutobudgetCampaignWithCustomStrategy> getTypeClass() {
        return InternalAutobudgetCampaignWithCustomStrategy.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addContainer,
                               List<InternalAutobudgetCampaignWithCustomStrategy> models) {
        boolean isPackageStrategiesStageTwoEnabled =
                featureService.isEnabledForClientId(addContainer.getClientId(),
                        PACKAGE_STRATEGIES_STAGE_TWO);
        // проставляем цель из стратегии в rotationGoalId
        models.stream()
                .filter(model -> model.getStrategy() != null && model.getStrategy().getStrategyData() != null
                        || isCampaignWithPackageStrategyAndStrategyIdIsValid(isPackageStrategiesStageTwoEnabled,
                        model))
                .forEach(model -> setRotationGoalId(addContainer, model, isPackageStrategiesStageTwoEnabled));
    }

    private void setRotationGoalId(RestrictedCampaignsAddOperationContainer addContainer,
                                   InternalAutobudgetCampaignWithCustomStrategy model,
                                   boolean isPackageStrategiesStageTwoEnabled) {
        if (isCampaignWithPackageStrategyAndStrategyIdIsValid(isPackageStrategiesStageTwoEnabled, model)) {
            var strategyId = ((CampaignWithPackageStrategy) model).getStrategyId();
            var strategy = addContainer.getPackageStrategy(strategyId);
            model.setRotationGoalId(((StrategyWithConversion) strategy).getGoalId()); // делаем каст,
            // тк на этапе preValidate проверили, что тип стратегии консиcтентен типу кампании, а значит у нее должна
            // быть цель
        } else {
            model.setRotationGoalId(model.getStrategy().getStrategyData().getGoalId());
        }

    }

    private boolean isCampaignWithPackageStrategyAndStrategyIdIsValid(boolean isPackageStrategiesStageTwoEnabled,
                                                                      InternalAutobudgetCampaignWithCustomStrategy campaign) {
        return isPackageStrategiesStageTwoEnabled
                && campaign instanceof CampaignWithPackageStrategy
                && isValidId(((CampaignWithPackageStrategy) campaign).getStrategyId());
    }

}
