package ru.yandex.direct.core.entity.campaign.service.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.campaign.model.DbStrategyBase;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaignWithCustomStrategy;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils;
import ru.yandex.direct.core.entity.feature.service.FeatureService;

import static ru.yandex.direct.feature.FeatureName.PACKAGE_STRATEGIES_STAGE_TWO;
import static ru.yandex.direct.utils.CommonUtils.isValidId;

@Component
@ParametersAreNonnullByDefault
public class MobileContentCampaignWithCustomStrategyAddOperationSupport
        extends AbstractCampaignAddOperationSupport<MobileContentCampaignWithCustomStrategy> {

    private final FeatureService featureService;

    @Autowired
    public MobileContentCampaignWithCustomStrategyAddOperationSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<MobileContentCampaignWithCustomStrategy> getTypeClass() {
        return MobileContentCampaignWithCustomStrategy.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addContainer,
                               List<MobileContentCampaignWithCustomStrategy> models) {
        boolean isPackageStrategiesStageTwoEnabled =
                featureService.isEnabledForClientId(addContainer.getClientId(), PACKAGE_STRATEGIES_STAGE_TWO);

        // Для РМП кампании с CPI стратегией при выборе цели 'Установки приложения' goalId = null
        StreamEx.of(models)
                .filter(model ->
                        !isCampaignWithPackageStrategyAndStrategyIdIsValid(isPackageStrategiesStageTwoEnabled, model)
                                && model.getStrategy() != null)
                .map(MobileContentCampaignWithCustomStrategy::getStrategy)
                .filter(CampaignWithStrategyValidationUtils::isCpiStrategyWithDefaultGoalId)
                .map(DbStrategyBase::getStrategyData)
                .forEach(data -> data
                        .withGoalId(null));
    }

    private boolean isCampaignWithPackageStrategyAndStrategyIdIsValid(boolean isPackageStrategiesStageTwoEnabled,
                                                                      MobileContentCampaignWithCustomStrategy campaign) {
        return isPackageStrategiesStageTwoEnabled
                && campaign instanceof CampaignWithPackageStrategy
                && isValidId(((CampaignWithPackageStrategy) campaign).getStrategyId());
    }
}
