package ru.yandex.direct.core.entity.campaign.service.type.add.container;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNetworkSettings;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.service.type.add.AbstractCampaignAddOperationSupport;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAutobudget;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.AUTO_CONTEXT_LIMIT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.THE_ONLY_VALID_CONTEXT_PRICE_COEF;
import static ru.yandex.direct.feature.FeatureName.PACKAGE_STRATEGIES_STAGE_TWO;
import static ru.yandex.direct.utils.CommonUtils.isValidId;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNetworkSettingsAddOperationSupport extends AbstractCampaignAddOperationSupport<CampaignWithNetworkSettings> {

    @Autowired
    public FeatureService featureService;

    @Override
    public Class<CampaignWithNetworkSettings> getTypeClass() {
        return CampaignWithNetworkSettings.class;
    }

    @Override
    public void onPreValidated(RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                               List<CampaignWithNetworkSettings> campaigns) {
        //После DIRECT-99592 ContextPriceCoef имеет только одно валидное значение — 100
        boolean isPackageStrategiesStageTwoEnabled =
                featureService.isEnabledForClientId(addCampaignParametersContainer.getClientId(),
                        PACKAGE_STRATEGIES_STAGE_TWO);

        campaigns.forEach(campaign -> {
            boolean isAutoBudgetStrategy;
            boolean isDifferentPlacesEnabled;

            if (isCampaignWithPackageStrategyAndStrategyIdValid(isPackageStrategiesStageTwoEnabled, campaign)) {
                Long strategyId = ((CampaignWithPackageStrategy) campaign).getStrategyId();
                var packageStrategy = addCampaignParametersContainer.getPackageStrategy(strategyId);

                isAutoBudgetStrategy = packageStrategy instanceof StrategyWithAutobudget;
                //isDifferentPlacesEnabled поле является устаревшим и де-факто всегда включено
                isDifferentPlacesEnabled = true;
            } else {
                DbStrategy campaignStrategy = campaign.getStrategy();
                isAutoBudgetStrategy = campaignStrategy.isAutoBudget();
                isDifferentPlacesEnabled = campaignStrategy.isDifferentPlaces();
            }

            campaign.setContextPriceCoef(THE_ONLY_VALID_CONTEXT_PRICE_COEF);
            if (isAutoBudgetStrategy && Boolean.TRUE.equals(campaign.getEnableCpcHold())) {
                campaign.setEnableCpcHold(false);
            }
            if (isAutoBudgetStrategy || isDifferentPlacesEnabled || campaign.getContextLimit() == null) {
                campaign.setContextLimit(AUTO_CONTEXT_LIMIT);
            }
        });
    }

    private boolean isCampaignWithPackageStrategyAndStrategyIdValid(boolean isPackageStrategiesStageTwoEnabled,
                                                                    CampaignWithNetworkSettings campaign) {
        return isPackageStrategiesStageTwoEnabled
                && campaign instanceof CampaignWithPackageStrategy
                && isValidId(((CampaignWithPackageStrategy) campaign).getStrategyId());
    }
}
