package ru.yandex.direct.core.entity.campaign.service.type.add.container;

import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.campaign.service.type.RestrictedCampaignsOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.dbutil.model.ClientId;

import static java.util.Collections.emptyMap;

/**
 * Контейнер с данными операции добавления кампании
 * {@link ru.yandex.direct.core.entity.campaign.service.RestrictedCampaignsAddOperation}
 */
public interface RestrictedCampaignsAddOperationContainer extends RestrictedCampaignsOperationContainer,
        CampaignValidationContainer {

    /**
     * Контейнеры - волатильные сущности. Лучше ограниченно создавать их в коде и особенно в тестах, этот метод
     * оставлен для совместимости.
     */
    static RestrictedCampaignsAddOperationContainer create(
            int shard,
            Long operatorUid,
            ClientId clientId,
            Long uid,
            Long chiefUid) {
        return new RestrictedCampaignsAddOperationContainerImpl(shard, operatorUid, clientId, uid, chiefUid,
                null, new CampaignOptions(), null, emptyMap());
    }

    boolean isCopyInOneClient();

    boolean isReadyToModerate();

}
