package ru.yandex.direct.core.entity.campaign.service.type.add.container;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.campaign.service.RequestBasedMetrikaClientAdapter;
import ru.yandex.direct.core.entity.campaign.service.type.AbstractRestrictedCampaignsOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.type.disabled.DisabledFieldsDataContainer;
import ru.yandex.direct.core.entity.strategy.model.BaseStrategy;
import ru.yandex.direct.dbutil.model.ClientId;

import static java.util.Collections.emptyList;
import static java.util.Collections.emptyMap;

@ParametersAreNonnullByDefault
public class RestrictedCampaignsAddOperationContainerImpl extends AbstractRestrictedCampaignsOperationContainer
        implements RestrictedCampaignsAddOperationContainer {

    private final Map<BaseCampaign, Boolean> requireServicingMap = new IdentityHashMap<>();
    private Map<Long, Long> goalIdToCounterIdForCampaignsWithoutCounterIds = emptyMap();

    public RestrictedCampaignsAddOperationContainerImpl(
            int shard,
            Long operatorUid,
            ClientId clientId,
            Long clientUid,
            Long chiefUid,
            @Nullable List<? extends BaseCampaign> campaignsToAdd, // требуется при заполненном options.requireServicing
            CampaignOptions options,
            RequestBasedMetrikaClientAdapter metrikaClientAdapter,
            Map<Long, BaseStrategy> clientPackageStrategyFromOperationById) {
        super(shard, operatorUid, clientId, clientUid, chiefUid, options, metrikaClientAdapter,
                clientPackageStrategyFromOperationById, new DisabledFieldsDataContainer(emptyList()));
        List<Boolean> requireServicingList = options.getRequireServicing();
        if (requireServicingList != null) {
            EntryStream.zip(Objects.requireNonNull(campaignsToAdd), requireServicingList)
                    .forKeyValue(requireServicingMap::put);
        }
    }

    @Override
    public boolean isCopy() {
        return options.isCopy();
    }

    @Override
    public boolean isCopyInOneClient() {
        return options.isCopyInOneClient();
    }

    @Override
    public CampaignType getCampaignType(Long campaignId) {
        throw new IllegalStateException("getCampaignType is not supported on add");
    }

    @Override
    public Class<? extends BaseCampaign> getRuntimeClass(@NotNull Long modelId) {
        throw new IllegalStateException("getRuntimeClass is not supported on add");
    }

    @Override
    public boolean skipValidateMobileApp() {
        return options.getSkipValidateMobileApp();
    }

    @Nullable
    @Override
    public Boolean getRequireServicing(BaseCampaign campaign) {
        return requireServicingMap.get(campaign);
    }

    @Override
    public boolean isReadyToModerate() {
        return options.isReadyToModerate();
    }

    public void setGoalIdToCounterIdForCampaignsWithoutCounterIds(
            Map<Long, Long> goalIdToCounterIdForCampaignsWithoutCounterIds) {
        this.goalIdToCounterIdForCampaignsWithoutCounterIds = goalIdToCounterIdForCampaignsWithoutCounterIds;
    }

    @Override
    public Map<Long, Long> getGoalIdToCounterIdForCampaignsWithoutCounterIds() {
        return goalIdToCounterIdForCampaignsWithoutCounterIds;
    }

}
