package ru.yandex.direct.core.entity.campaign.service.type.add.utils

import one.util.streamex.EntryStream
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign
import ru.yandex.direct.core.entity.campaign.service.type.add.UidWithCampaignIds
import ru.yandex.direct.core.entity.campaign.service.type.add.container.AddServicedCampaignInfo
import java.util.stream.Collectors.toList

fun <T : BaseCampaign> getManagerUidWithServicedCampaignIds(
    servicedInfos: List<AddServicedCampaignInfo>,
    campaigns: List<T>):
    UidWithCampaignIds? =

    getManagerUidWithServicedCampaignsBasic(servicedInfos, campaigns)
        .mapValues(BaseCampaign::getId)
        .collapseKeys(toList())
        // в одной операции 1 клиент, а у одного клиента всегда 1 primary manager, поэтому всегда вернётся не более
        // 1 элемента
        .findFirst()
        .map { (uid, campaignIds) -> UidWithCampaignIds(uid!!, campaignIds) }
        .orElse(null)

/**
 * Возвращает EntryStream в котором ключи это не-null managerUid, а значения - кампании
 */
private fun <T> getManagerUidWithServicedCampaignsBasic(
    servicedInfos: List<AddServicedCampaignInfo>,
    campaigns: List<T>): EntryStream<Long?, T> =
    EntryStream.zip(servicedInfos, campaigns)
        .filterKeys(AddServicedCampaignInfo::getIsServiced)
        .mapKeys(AddServicedCampaignInfo::getManagerUid)