package ru.yandex.direct.core.entity.campaign.service.type.update;

import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.strategy.service.update.StrategyUpdateOperationTypeSupportFacade;
import ru.yandex.direct.multitype.service.type.update.AbstractUpdateOperationTypeSupport;

/**
 * В рамках {@link ru.yandex.direct.core.entity.strategy.service.CampaignUpdateHelper} используем саппорты для
 * обновления данных кампании
 * в случае обновления/добавления пакетной стратегии.
 * <p>
 * Саппорт {@link CampaignWithPackageStrategyUpdateOperationSupport} в свою очередь зависит от
 * {@link StrategyUpdateOperationTypeSupportFacade},
 * что приводит к циклической зависимости при инициализации контекста спринга.
 * Поэтому саппорт обновления для интерфейса {@link CampaignWithPackageStrategy} не наследует
 * {@link BaseCampaignUpdateOperationSupport},
 * в отличие от саппортов обновления для остальных интерфейсов.
 */
public abstract class AbstractCampaignWithPackageUpdateOperationSupport
        extends AbstractUpdateOperationTypeSupport<CampaignWithPackageStrategy,
        RestrictedCampaignsUpdateOperationContainer,
        CampaignAdditionalActionsContainer, RestrictedCampaignsUpdateOperationContainer>
        implements CampaignUpdateOperationSupport<CampaignWithPackageStrategy> {
}
