package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationTypeSupportFacade;

import static ru.yandex.direct.core.entity.campaign.service.CampaignUpdateOperationConstants.CAMPAIGN_TYPE_SUPPORT_CLASS_WHITE_LIST;

@Component
@ParametersAreNonnullByDefault
public class CampaignUpdateOperationSupportFacade extends UpdateOperationTypeSupportFacade<BaseCampaign,
        RestrictedCampaignsUpdateOperationContainer, CampaignAdditionalActionsContainer,
        RestrictedCampaignsUpdateOperationContainer> {

    @Autowired
    public CampaignUpdateOperationSupportFacade(List<CampaignUpdateOperationSupport<? extends BaseCampaign>> supports) {
        super(supports, CAMPAIGN_TYPE_SUPPORT_CLASS_WHITE_LIST);
    }

    public CampaignUpdateOperationSupportFacade(List<CampaignUpdateOperationSupport<? extends BaseCampaign>> supports,
                                                Set<Class<? extends BaseCampaign>> whiteListSupportTypeClass) {
        super(supports, whiteListSupportTypeClass);
    }
}
