package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAttributionModel;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstantsService;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAttributionModelUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithAttributionModel> {

    private final CampaignConstantsService campaignConstantsService;

    @Autowired
    public CampaignWithAttributionModelUpdateOperationSupport(CampaignConstantsService campaignConstantsService) {
        this.campaignConstantsService = campaignConstantsService;
    }

    @Override
    public Class<CampaignWithAttributionModel> getTypeClass() {
        return CampaignWithAttributionModel.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer container,
                                 List<AppliedChanges<CampaignWithAttributionModel>> appliedChanges) {
        appliedChanges.forEach(changes -> CampaignConverter.modifyFieldIfNull(changes,
                CampaignWithAttributionModel.ATTRIBUTION_MODEL, campaignConstantsService.getDefaultAttributionModel()));
    }
}
