package ru.yandex.direct.core.entity.campaign.service.type.update

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBannerHrefParams
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer
import ru.yandex.direct.core.entity.campaign.service.type.utils.BannerHrefParamsUtils.sanitizeHrefParams
import ru.yandex.direct.model.AppliedChanges

@Component
class CampaignWithBannerHrefParamsTypesUpdateOperationSupport :
    AbstractCampaignUpdateOperationSupport<CampaignWithBannerHrefParams>() {
    override fun getTypeClass(): Class<CampaignWithBannerHrefParams> = CampaignWithBannerHrefParams::class.java

    override fun onChangesApplied(
        updateContainer: RestrictedCampaignsUpdateOperationContainer,
        appliedChanges: MutableList<AppliedChanges<CampaignWithBannerHrefParams>>
    ) {
        appliedChanges.map { it.model }
            .forEach {
                it.bannerHrefParams = sanitizeHrefParams(it.bannerHrefParams)
            }
    }
}
