package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandSafety;
import ru.yandex.direct.core.entity.campaign.service.CampaignWithBrandSafetyService;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBrandSafetyUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithBrandSafety> {

    private final CampaignWithBrandSafetyService campaignWithBrandSafetyService;

    @Autowired
    public CampaignWithBrandSafetyUpdateOperationSupport(CampaignWithBrandSafetyService campaignWithBrandSafetyService) {
        this.campaignWithBrandSafetyService = campaignWithBrandSafetyService;
    }

    @Override
    public Class<CampaignWithBrandSafety> getTypeClass() {
        return CampaignWithBrandSafety.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsUpdateOperationContainer updateParameters,
                                List<AppliedChanges<CampaignWithBrandSafety>> appliedChanges) {
        List<CampaignWithBrandSafety> changedCampaigns = filterAndMapList(appliedChanges,
                ch -> ch.changed(CampaignWithBrandSafety.BRAND_SAFETY_CATEGORIES),
                AppliedChanges::getModel);

        Map<Long, Long> retCondIdByCampaignId = campaignWithBrandSafetyService.saveCategoriesAndGetRetCondIds(
                updateParameters.getShard(),
                updateParameters.getClientId(),
                changedCampaigns
        );

        appliedChanges
                .stream()
                .filter(ch -> ch.changed(CampaignWithBrandSafety.BRAND_SAFETY_CATEGORIES))
                .forEach(ch -> ch.modify(CampaignWithBrandSafety.BRAND_SAFETY_RET_COND_ID,
                        retCondIdByCampaignId.getOrDefault(ch.getModel().getId(), null)));
    }
}
