package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCampaignsPromotions;
import ru.yandex.direct.core.entity.campaign.model.CampaignsPromotion;
import ru.yandex.direct.core.entity.campaign.repository.CampaignsPromotionsRepository;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCampaignsPromotionsUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithCampaignsPromotions> {
    private final CampaignsPromotionsRepository campaignsPromotionsRepository;

    @Autowired
    public CampaignWithCampaignsPromotionsUpdateOperationSupport(CampaignsPromotionsRepository campaignsPromotionsRepository) {
        this.campaignsPromotionsRepository = campaignsPromotionsRepository;
    }

    @Override
    public Class<CampaignWithCampaignsPromotions> getTypeClass() {
        return CampaignWithCampaignsPromotions.class;
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext,
                                                   RestrictedCampaignsUpdateOperationContainer updateParameters,
                                                   List<AppliedChanges<CampaignWithCampaignsPromotions>> appliedChanges) {
        List<CampaignWithCampaignsPromotions> campaignWithCampaignsPromotionsList = filterAndMapList(
                appliedChanges,
                ac -> ac.changed(CampaignWithCampaignsPromotions.CAMPAIGNS_PROMOTIONS),
                AppliedChanges::getModel);

        Map<Long, List<CampaignsPromotion>> cidsToCampaignsPromotions = StreamEx.of(campaignWithCampaignsPromotionsList)
                .toMap(CampaignWithCampaignsPromotions::getId, CampaignWithCampaignsPromotions::getCampaignsPromotions);

        campaignsPromotionsRepository.updateCampaignsPromotions(dslContext, cidsToCampaignsPromotions);
    }
}
