package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncPriority;
import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithContentLanguage;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.CommonUtils.isValidId;
import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithContentLanguageUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithContentLanguage> {

    @Override
    public Class<CampaignWithContentLanguage> getTypeClass() {
        return CampaignWithContentLanguage.class;
    }

    @Override
    public void addToAdditionalActionsContainer(CampaignAdditionalActionsContainer additionalActionsContainer,
                                                RestrictedCampaignsUpdateOperationContainer updateParameters,
                                                List<AppliedChanges<CampaignWithContentLanguage>> appliedChanges) {
        Set<Long> campaignIdsWithChangedContentLanguage = filterAndMapToSet(appliedChanges,
                ac -> ac.changed(CampaignWithContentLanguage.CONTENT_LANGUAGE) && isValidId(ac.getModel().getOrderId()),
                ac -> ac.getModel().getId());

        additionalActionsContainer.addCampaignBannersToBsResyncQueue(
                BsResyncPriority.CHANGE_CAMP_CONTENT_LANG, campaignIdsWithChangedContentLanguage);
    }

}
