package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCreatingEmptyStatForGoals;
import ru.yandex.direct.core.entity.campaign.service.CampMetrikaGoalsService;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.metrika.container.CampaignTypeWithCounterIds;
import ru.yandex.direct.core.entity.metrika.service.campaigngoals.CampaignGoalsService;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCreatingEmptyStatForGoalsUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithCreatingEmptyStatForGoals> {

    private final CampMetrikaGoalsService campMetrikaGoalsService;
    private final CampaignGoalsService campaignGoalsService;

    @Autowired
    public CampaignWithCreatingEmptyStatForGoalsUpdateOperationSupport(CampMetrikaGoalsService campMetrikaGoalsService, CampaignGoalsService campaignGoalsService) {
        this.campMetrikaGoalsService = campMetrikaGoalsService;
        this.campaignGoalsService = campaignGoalsService;
    }

    @Override
    public Class<CampaignWithCreatingEmptyStatForGoals> getTypeClass() {
        return CampaignWithCreatingEmptyStatForGoals.class;
    }

    @Override
    public void updateRelatedEntitiesOutOfTransactionWithModelChanges(RestrictedCampaignsUpdateOperationContainer container,
                                                                      List<ModelChanges<CampaignWithCreatingEmptyStatForGoals>> modelChanges,
                                                                      List<AppliedChanges<CampaignWithCreatingEmptyStatForGoals>> appliedChanges) {

        List<CampaignWithCreatingEmptyStatForGoals> campaignsToUpdateGoals = new ArrayList<>();
        appliedChanges.forEach(changes -> {
            if (changes.getNewValue(CampaignWithCreatingEmptyStatForGoals.METRIKA_COUNTERS) != null) {
                campaignsToUpdateGoals.add(changes.getModel());
            }
        });

        if(campaignsToUpdateGoals.isEmpty()) {
            return;
        }

        Map<Long, CampaignTypeWithCounterIds> campaignTypeWithCounterIdsByCampaignId =
                listToMap(campaignsToUpdateGoals, CampaignWithCreatingEmptyStatForGoals::getId,
                        campaign -> new CampaignTypeWithCounterIds()
                                .withCampaignType(campaign.getType())
                                .withCounterIds(listToSet(campaign.getMetrikaCounters())));

        var availableGoalsForCampaign =
                campaignGoalsService.getAvailableGoalsForCampaignId(container.getOperatorUid(),
                container.getClientId(),
                campaignTypeWithCounterIdsByCampaignId,
                container.getMetrikaClient()
                );

        var availableGoalsForCampaignByCounterIds = StreamEx.of(availableGoalsForCampaign.values())
                .flatMap(Collection::stream)
                .mapToEntry(Goal::getCounterId, Function.identity())
                .nonNullKeys()
                .mapKeys(Integer::longValue)
                .grouping(Collectors.toSet());

        campMetrikaGoalsService.addCampMetrikaGoals(
                container.getShard(),
                container.getClientId(),
                campaignsToUpdateGoals,
                availableGoalsForCampaignByCounterIds
        );
    }
}
