package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.BooleanUtils;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomCheckPositionEvent;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCustomCheckPositionEventUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithCustomCheckPositionEvent> {

    @Override
    public Class<CampaignWithCustomCheckPositionEvent> getTypeClass() {
        return CampaignWithCustomCheckPositionEvent.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer container,
                                 List<AppliedChanges<CampaignWithCustomCheckPositionEvent>> appliedChanges) {
        appliedChanges.stream()
                .filter(changes -> BooleanUtils.isFalse(changes.getModel().getEnableCheckPositionEvent()))
                // проставляем старое значение, чтобы не перезатирать
                .forEach(changes -> CampaignConverter.setOldValueIfNewNull(changes,
                        CampaignWithCustomCheckPositionEvent.CHECK_POSITION_INTERVAL_EVENT)
                );
    }

}
