package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.container.CampaignStrategyChangingSettings;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDefaultPriceRecalculation;
import ru.yandex.direct.core.entity.campaign.service.pricerecalculation.CommonCampaignPriceRecalculationService;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.getTextCampaignStrategyChangingSettings;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDefaultPriceRecalculationUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithDefaultPriceRecalculation> {
    private CommonCampaignPriceRecalculationService commonCampaignPriceRecalculationService;

    @Autowired
    public CampaignWithDefaultPriceRecalculationUpdateOperationSupport(
            CommonCampaignPriceRecalculationService commonCampaignPriceRecalculationService) {
        this.commonCampaignPriceRecalculationService = commonCampaignPriceRecalculationService;
    }

    @Override
    public Class<CampaignWithDefaultPriceRecalculation> getTypeClass() {
        return CampaignWithDefaultPriceRecalculation.class;
    }

    @Override
    public void updateRelatedEntitiesOutOfTransaction(
            RestrictedCampaignsUpdateOperationContainer updateContainer,
            List<AppliedChanges<CampaignWithDefaultPriceRecalculation>> appliedChanges) {
        CampaignStrategyChangingSettings settings = getTextCampaignStrategyChangingSettings(appliedChanges);

        commonCampaignPriceRecalculationService.afterTextCampaignsStrategyChanged(
                filterList(appliedChanges, ac -> ac.changed(CampaignWithDefaultPriceRecalculation.STRATEGY)),
                settings,
                updateContainer.getOperatorUid(),
                UidAndClientId.of(updateContainer.getChiefUid(),
                        updateContainer.getClientId()));
    }
}
