package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDialog;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDialogUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithDialog> {

    @Override
    public Class<CampaignWithDialog> getTypeClass() {
        return CampaignWithDialog.class;
    }

    @Override
    public void addToAdditionalActionsContainer(CampaignAdditionalActionsContainer additionalActionsContainer,
                                                RestrictedCampaignsUpdateOperationContainer updateParameters,
                                                List<AppliedChanges<CampaignWithDialog>> appliedChanges) {
        Set<Long> campaignIdsWithChangedDialogId = filterAndMapToSet(appliedChanges,
                ac -> ac.changed(CampaignWithDialog.CLIENT_DIALOG_ID),
                ac -> ac.getModel().getId());

        additionalActionsContainer.resetCampaignBannersStatusBsSynced(campaignIdsWithChangedDialogId);
    }
}
