package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledDomainsAndSsp;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService;
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.utils.StringUtils;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisabledDomainsAndSspUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithDisabledDomainsAndSsp> {

    private final HostingsHandler hostingsHandler;
    private final DisableDomainValidationService disableDomainValidationService;

    @Autowired
    public CampaignWithDisabledDomainsAndSspUpdateOperationSupport(HostingsHandler hostingsHandler,
                                                                   DisableDomainValidationService disableDomainValidationService) {
        this.hostingsHandler = hostingsHandler;
        this.disableDomainValidationService = disableDomainValidationService;
    }

    @Override
    public Class<CampaignWithDisabledDomainsAndSsp> getTypeClass() {
        return CampaignWithDisabledDomainsAndSsp.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer container,
                                 List<AppliedChanges<CampaignWithDisabledDomainsAndSsp>> appliedChanges) {
        appliedChanges.forEach(changes -> {
            List<String> newDomains = changes.getNewValue(CampaignWithDisabledDomainsAndSsp.DISABLED_DOMAINS);
            if (changes.changed(CampaignWithDisabledDomainsAndSsp.DISABLED_DOMAINS)) {
                if (newDomains != null) {
                    newDomains = mapList(newDomains, hostingsHandler::stripWww);
                    List<String> sspThatAlsoDomains = filterList(changes.getModel().getDisabledSsp(),
                            ssp -> disableDomainValidationService.isValidDomain(ssp, container.getClientId()));
                    if (sspThatAlsoDomains != null) {
                        newDomains.addAll(sspThatAlsoDomains);
                    }
                }
            } else {
                // DIRECT-173297: перл может писать в базу дубликаты, пролечим базу удалив их, иначе кампания не
                // пройдёт валидацию, (но если переданы новые значения, удалять не надо, чтобы показать ошибку о
                // дубликатах)
                newDomains = ifNotNull(newDomains, StringUtils::getDistinctStrings);
            }
            changes.modify(CampaignWithDisabledDomainsAndSsp.DISABLED_DOMAINS, newDomains);
        });
    }

}
