package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledVideoPlacements;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisabledVideoPlacementsUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithDisabledVideoPlacements> {

    private final HostingsHandler hostingsHandler;

    @Autowired
    public CampaignWithDisabledVideoPlacementsUpdateOperationSupport(HostingsHandler hostingsHandler) {
        this.hostingsHandler = hostingsHandler;
    }

    @Override
    public Class<CampaignWithDisabledVideoPlacements> getTypeClass() {
        return CampaignWithDisabledVideoPlacements.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer container,
                                 List<AppliedChanges<CampaignWithDisabledVideoPlacements>> appliedChanges) {
        appliedChanges.forEach(changes -> {
            if (changes.changed(CampaignWithDisabledVideoPlacements.DISABLED_VIDEO_PLACEMENTS)) {
                List<String> domains =
                        mapList(changes.getNewValue(CampaignWithDisabledVideoPlacements.DISABLED_VIDEO_PLACEMENTS),
                                hostingsHandler::stripWww);
                changes.modify(CampaignWithDisabledVideoPlacements.DISABLED_VIDEO_PLACEMENTS, domains);
            }
        });
    }

}
