package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCompanyInfoForbiddenAndEnabled;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEnableCompanyInfoForbiddenAndEnabledUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithEnableCompanyInfoForbiddenAndEnabled> {
    @Override
    public Class<CampaignWithEnableCompanyInfoForbiddenAndEnabled> getTypeClass() {
        return CampaignWithEnableCompanyInfoForbiddenAndEnabled.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                 List<AppliedChanges<CampaignWithEnableCompanyInfoForbiddenAndEnabled>> appliedChanges) {
        appliedChanges.forEach(changes -> changes.modify(CampaignWithEnableCompanyInfoForbiddenAndEnabled.ENABLE_COMPANY_INFO, true));
    }
}
