package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEshowsSettingsAndStrategy;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.EshowsSettings;
import ru.yandex.direct.core.entity.campaign.model.EshowsVideoType;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEshowsSettingsAndStrategyUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithEshowsSettingsAndStrategy> {

    @Override
    public Class<CampaignWithEshowsSettingsAndStrategy> getTypeClass() {
        return CampaignWithEshowsSettingsAndStrategy.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                List<AppliedChanges<CampaignWithEshowsSettingsAndStrategy>> appliedChanges) {
        // Сбрасываем невалидные значения eshowsSettings->videoType в зависимости от стратегии
        appliedChanges.forEach(ac -> {
            EshowsSettings eshowsSettings = ac.getNewValue(CampaignWithEshowsSettingsAndStrategy.ESHOWS_SETTINGS);
            EshowsVideoType videoType = eshowsSettings.getVideoType();
            EshowsSettings oldEshowsSettings = ac.getOldValue(CampaignWithEshowsSettingsAndStrategy.ESHOWS_SETTINGS);
            DbStrategy oldStrategy = ac.getOldValue(CampaignWithEshowsSettingsAndStrategy.STRATEGY);
            StrategyName oldStrategyName = oldStrategy.getStrategyName();
            Boolean isAvgCpvOldStrategy = oldStrategyName.equals(StrategyName.AUTOBUDGET_AVG_CPV) ||
                    oldStrategyName.equals(StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD);
            DbStrategy strategy = ac.getNewValue(CampaignWithEshowsSettingsAndStrategy.STRATEGY);
            StrategyName strategyName = strategy.getStrategyName();
            Boolean isAvgCpvStrategy = strategyName.equals(StrategyName.AUTOBUDGET_AVG_CPV) ||
                    strategyName.equals(StrategyName.AUTOBUDGET_AVG_CPV_CUSTOM_PERIOD);

            if (isAvgCpvStrategy) {
                ac.modify(CampaignWithEshowsSettingsAndStrategy.ESHOWS_SETTINGS, new EshowsSettings()
                        .withBannerRate(eshowsSettings.getBannerRate())
                        .withVideoRate(eshowsSettings.getVideoRate())
                        .withVideoType(null));
            } else if (videoType == null) {
                if (isAvgCpvOldStrategy) {
                    ac.modify(CampaignWithEshowsSettingsAndStrategy.ESHOWS_SETTINGS, new EshowsSettings()
                            .withBannerRate(eshowsSettings.getBannerRate())
                            .withVideoRate(eshowsSettings.getVideoRate())
                            .withVideoType(EshowsVideoType.COMPLETES));
                } else {
                    ac.modify(CampaignWithEshowsSettingsAndStrategy.ESHOWS_SETTINGS, oldEshowsSettings);
                }
            }
        });
    }
}
