package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignExperiment;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithExperiments;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.core.entity.retargeting.model.ExperimentRetargetingConditions;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.retargeting.converter.ExperimentConverter.getExperimentIdsIfNotEmpty;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithExperimentsUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithExperiments> {

    private final RetargetingConditionService retargetingConditionService;
    private final FeatureService featureService;

    @Autowired
    public CampaignWithExperimentsUpdateOperationSupport(RetargetingConditionService retargetingConditionService,
                                                         FeatureService featureService) {
        this.retargetingConditionService = retargetingConditionService;
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithExperiments> getTypeClass() {
        return CampaignWithExperiments.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsUpdateOperationContainer updateParameters,
                                List<AppliedChanges<CampaignWithExperiments>> appliedChanges) {

        boolean experimentRetargetingConditionsAutoCreatingEnabledForClientId =
                featureService.isEnabledForClientId(updateParameters.getClientId(),
                        FeatureName.EXPERIMENT_RET_CONDITIONS_CREATING_ON_TEXT_CAMPAIGNS_MODIFY_IN_JAVA_FOR_DNA);

        if (experimentRetargetingConditionsAutoCreatingEnabledForClientId) {
            List<CampaignExperiment> campaignExperiments = mapList(appliedChanges, item -> new CampaignExperiment()
                    .withAbSegmentGoalIds(getExperimentIdsIfNotEmpty(item.getModel().getAbSegmentGoalIds()))
                    .withSectionIds(getExperimentIdsIfNotEmpty(item.getModel().getSectionIds())));

            List<ExperimentRetargetingConditions> experimentRetargetingConditions =
                    retargetingConditionService.findOrCreateExperimentsRetargetingConditions(
                            updateParameters.getClientId(),
                            campaignExperiments,
                            updateParameters.getMetrikaClient().getAbSegmentGoals(),
                             null);

            EntryStream.of(appliedChanges)
                    .forKeyValue((index, ac) -> updateCampaignWithExperimentRetargetingConditions(ac,
                            experimentRetargetingConditions.get(index)));
        }
    }

    private void updateCampaignWithExperimentRetargetingConditions(
            AppliedChanges<CampaignWithExperiments> campaignAppliedChanges,
            ExperimentRetargetingConditions experimentRetargetingConditions) {

        campaignAppliedChanges.modify(CampaignWithExperiments.AB_SEGMENT_RETARGETING_CONDITION_ID,
                experimentRetargetingConditions.getRetargetingConditionId());

        campaignAppliedChanges.modify(CampaignWithExperiments.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID,
                experimentRetargetingConditions.getStatisticRetargetingConditionId());
    }
}
