package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.autobudget.service.AutobudgetAlertService;
import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithFreezingStrategyAlerts;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithFreezingStrategyAlertsUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithFreezingStrategyAlerts> {

    private AutobudgetAlertService autobudgetAlertService;

    @Autowired
    public CampaignWithFreezingStrategyAlertsUpdateOperationSupport(AutobudgetAlertService autobudgetAlertService) {
        this.autobudgetAlertService = autobudgetAlertService;
    }

    @Override
    public Class<CampaignWithFreezingStrategyAlerts> getTypeClass() {
        return CampaignWithFreezingStrategyAlerts.class;
    }

    @Override
    public void addToAdditionalActionsContainer(CampaignAdditionalActionsContainer additionalActionsContainer,
                                                RestrictedCampaignsUpdateOperationContainer updateParameters,
                                                List<AppliedChanges<CampaignWithFreezingStrategyAlerts>> appliedChanges) {
        additionalActionsContainer.addCampaignsToFreezeAlerts(
                autobudgetAlertService.getCampaignsToFreezeAlertsOnStrategyChange(
                        updateParameters.getClientId(), appliedChanges)
        );
    }
}
