package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoalsWithRequiredFields;
import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.core.entity.campaign.service.MeaningfulGoalUtils;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMeaningfulGoalsTypesUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithMeaningfulGoalsWithRequiredFields> {
    @Override
    public Class<CampaignWithMeaningfulGoalsWithRequiredFields> getTypeClass() {
        return CampaignWithMeaningfulGoalsWithRequiredFields.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer container,
                                 List<AppliedChanges<CampaignWithMeaningfulGoalsWithRequiredFields>> appliedChanges) {
        appliedChanges.forEach(this::removeDefaultGoals);
    }

    /**
     * Фронт может присылать дефолтную цель(ака Вовлеченные Сессии) без value. Её записывать в базу не следует.
     */
    private void removeDefaultGoals(AppliedChanges<
            CampaignWithMeaningfulGoalsWithRequiredFields> campaignWithMeaningfulGoalsChanges) {
        if (campaignWithMeaningfulGoalsChanges.getModel().getMeaningfulGoals() == null) {
            return;
        }
        List<MeaningfulGoal> meaningfulGoalsWithoutDefault =
                StreamEx.of(campaignWithMeaningfulGoalsChanges.getModel().getMeaningfulGoals())
                        .remove(MeaningfulGoalUtils::goalIsDefault)
                        .toList();
        campaignWithMeaningfulGoalsChanges.getModel().setMeaningfulGoals(meaningfulGoalsWithoutDefault);
    }

    @Override
    public void onAppliedChangesValidated(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                          List<AppliedChanges<CampaignWithMeaningfulGoalsWithRequiredFields>> appliedChanges) {
        appliedChanges.forEach(this::removeMetrikaValueSource);
    }

    /**
     * Если фронт изменил стратегию из ДРР. Метрика, как источник value для кц становится недоступной.
     * Чтобы в массовых изменениях стратегии, не ловить ошибку валидации -- сбрасываем флажок.
     */

    private void removeMetrikaValueSource(
            AppliedChanges<CampaignWithMeaningfulGoalsWithRequiredFields> campaignWithMeaningfulGoalsChanges) {
        CampaignWithMeaningfulGoalsWithRequiredFields model = campaignWithMeaningfulGoalsChanges.getModel();
        if (model.getMeaningfulGoals() == null) {
            return;
        }

        if (model.getStrategy().getStrategyName() != StrategyName.AUTOBUDGET_CRR) {
            List<MeaningfulGoal> newMeaningfulGoals = mapList(model.getMeaningfulGoals(),
                    // если в MeaningfulGoal будут добавляться поля, здесь их тоже нужно добавить
                    goal -> new MeaningfulGoal()
                            .withGoalId(goal.getGoalId())
                            .withConversionValue(goal.getConversionValue())
                            .withIsMetrikaSourceOfValue(null));
            campaignWithMeaningfulGoalsChanges.modify(CampaignWithMeaningfulGoalsWithRequiredFields.MEANINGFUL_GOALS,
                    newMeaningfulGoals);
        }
    }
}
