package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.repository.BannerRepository;
import ru.yandex.direct.core.entity.banner.type.measurers.BannerWithMeasurersUtils;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeasurers;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMeasurersUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithMeasurers> {
    private final FeatureService featureService;
    private final BannerRepository bannerRepository;

    public CampaignWithMeasurersUpdateOperationSupport(FeatureService featureService,
                                                       BannerRepository bannerRepository) {
        this.featureService = featureService;
        this.bannerRepository = bannerRepository;
    }

    @Override
    public Class<CampaignWithMeasurers> getTypeClass() {
        return CampaignWithMeasurers.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                List<AppliedChanges<CampaignWithMeasurers>> appliedChanges) {
        if(featureService.isEnabledForClientId(updateContainer.getClientId(), FeatureName.MOAT_USE_UNSTABLE_SCRIPT)) {
            appliedChanges.forEach(ac -> {
                if (ac.changed(CampaignWithMeasurers.MEASURERS)) {
                    var measurers = ac.getModel().getMeasurers();
                    BannerWithMeasurersUtils.setCampMoatUseUnstableScript(measurers);
                    ac.modify(CampaignWithMeasurers.MEASURERS, measurers);
                }
            });
        }
        //Включение-выключение измерителя на кампании должно сбрасывать флаг statusBsSynced на всех баннерах кампании
        var cidsChangedMesurers =  StreamEx.of(appliedChanges)
                .filter(ac -> (ac.changed(CampaignWithMeasurers.MEASURERS)))
                .map(ac -> ac.getModel().getId())
                .toSet();
        if (!cidsChangedMesurers.isEmpty()) {
            var bids = bannerRepository.relations
                    .getBannerIdsByCampaignIds(updateContainer.getShard(), cidsChangedMesurers);
            bannerRepository.common.resetStatusBsSyncedByIds(updateContainer.getShard(), bids);
        }
    }
}
