package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.service.MinusKeywordPreparingTool;
import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMinusKeywords;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.model.DynamicCampaign;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.utils.FunctionalUtils.filterList;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMinusKeywordsUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithMinusKeywords> {
    private final MinusKeywordPreparingTool minusKeywordPreparingTool;

    @Autowired
    public CampaignWithMinusKeywordsUpdateOperationSupport(
            MinusKeywordPreparingTool minusKeywordPreparingTool) {
        this.minusKeywordPreparingTool = minusKeywordPreparingTool;
    }

    @Override
    public Class<CampaignWithMinusKeywords> getTypeClass() {
        return CampaignWithMinusKeywords.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer container,
                                 List<AppliedChanges<CampaignWithMinusKeywords>> appliedChanges) {
        var actuallyChanged = filterList(appliedChanges,
                changes -> changes.changed(CampaignWithMinusKeywords.MINUS_KEYWORDS));
        actuallyChanged.forEach(changes -> {
                    List<String> minusKeywords = changes.getModel().getMinusKeywords();
                    if (minusKeywords != null) {
                        var preparedMinusKeywords = minusKeywordPreparingTool.fullPrepareForSaving(minusKeywords);
                        changes.modify(CampaignWithMinusKeywords.MINUS_KEYWORDS, preparedMinusKeywords);
                    }
                }
        );

        // Reset forecast date
        actuallyChanged.forEach(changes -> {
            changes.modify(CommonCampaign.AUTOBUDGET_FORECAST_DATE, null);
        });
    }

    @Override
    public void addToAdditionalActionsContainer(CampaignAdditionalActionsContainer additionalActionsContainer,
                                                RestrictedCampaignsUpdateOperationContainer updateParameters,
                                                List<AppliedChanges<CampaignWithMinusKeywords>> appliedChanges) {
        var campaignsWithChangedMinusKeywords = appliedChanges.stream()
                .filter(ac -> ac.changed(CampaignWithMinusKeywords.MINUS_KEYWORDS))
                .map(AppliedChanges::getModel)
                .collect(Collectors.toList());

        Set<Long> campaignIdsWithChangedMinusKeywords = listToSet(campaignsWithChangedMinusKeywords,
                BaseCampaign::getId);
        additionalActionsContainer.addCampaignIdsForUpdateStatusShowsForecast(campaignIdsWithChangedMinusKeywords);
        additionalActionsContainer.addCampaignIdsForUpdateBannersLastChange(campaignIdsWithChangedMinusKeywords);

        var dynamicCampaignsWithChangedMinusKeywords =
                StreamEx.of(campaignsWithChangedMinusKeywords)
                .select(DynamicCampaign.class)
                .map(BaseCampaign::getId)
                .toList();

        additionalActionsContainer
                .resetCampaignBannersStatusBsSyncedAndUpdateLastChange(dynamicCampaignsWithChangedMinusKeywords);
    }

}
