package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.repository.BannerRepository;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMobileContent;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMobileContentUpdateOperationSupport
        extends AbstractCampaignUpdateOperationSupport<CampaignWithMobileContent> {
    private final BannerRepository bannerRepository;

    public CampaignWithMobileContentUpdateOperationSupport(BannerRepository bannerRepository) {
        this.bannerRepository = bannerRepository;
    }

    @Override
    public Class<CampaignWithMobileContent> getTypeClass() {
        return CampaignWithMobileContent.class;
    }

    @Override
    public void beforeExecution(RestrictedCampaignsUpdateOperationContainer updateContainer,
                                List<AppliedChanges<CampaignWithMobileContent>> appliedChanges) {
        //Обновление альтернативных сторов у кампании должно сбрасывать флаг statusBsSynced на всех баннерах кампании
        var cidsChangedAltAppStores = StreamEx.of(appliedChanges)
                .filter(ac -> (ac.changed(CampaignWithMobileContent.ALTERNATIVE_APP_STORES)))
                .map(ac -> ac.getModel().getId())
                .toSet();
        if (!cidsChangedAltAppStores.isEmpty()) {
            var bids = bannerRepository.relations
                    .getBannerIdsByCampaignIds(updateContainer.getShard(), cidsChangedAltAppStores);
            bannerRepository.common.resetStatusBsSyncedByIds(updateContainer.getShard(), bids);
        }
    }
}
