package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.autobudget.service.AutobudgetAlertService;
import ru.yandex.direct.core.entity.campaign.container.CampaignAdditionalActionsContainer;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithNetworkSettings;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.AUTO_CONTEXT_LIMIT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.THE_ONLY_VALID_CONTEXT_PRICE_COEF;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNetworkSettingsUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithNetworkSettings> {
    @Autowired
    private AutobudgetAlertService autobudgetAlertService;

    @Override
    public Class<CampaignWithNetworkSettings> getTypeClass() {
        return CampaignWithNetworkSettings.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer container,
                                 List<AppliedChanges<CampaignWithNetworkSettings>> appliedChanges) {
        //После DIRECT-99592 ContextPriceCoef имеет только одно валидное значение — 100
        appliedChanges.forEach(changes -> {
            CampaignWithNetworkSettings campaign = changes.getModel();
            boolean isAutoBudget = campaign.getStrategy().isAutoBudget();
            boolean isDifferentPlaces = campaign.getStrategy().isDifferentPlaces();
            if (!campaign.getContextPriceCoef().equals(THE_ONLY_VALID_CONTEXT_PRICE_COEF)) {
                changes.modify(CampaignWithNetworkSettings.CONTEXT_PRICE_COEF, THE_ONLY_VALID_CONTEXT_PRICE_COEF);
            }
            if (isAutoBudget && campaign.getEnableCpcHold()) {
                changes.modify(CampaignWithNetworkSettings.ENABLE_CPC_HOLD, false);
            }
            if (isAutoBudget || isDifferentPlaces) {
                changes.modify(CampaignWithNetworkSettings.CONTEXT_LIMIT, AUTO_CONTEXT_LIMIT);
            }
        });
    }

    @Override
    public void addToAdditionalActionsContainer(CampaignAdditionalActionsContainer additionalActionsContainer,
                                                RestrictedCampaignsUpdateOperationContainer updateParameters,
                                                List<AppliedChanges<CampaignWithNetworkSettings>> appliedChanges) {
        additionalActionsContainer.addCampaignsToFreezeAlerts(
                autobudgetAlertService.getCampaignsToFreezeAlertsOnContextLimitChange(
                        updateParameters.getClientId(), appliedChanges)
        );
    }
}
