package ru.yandex.direct.core.entity.campaign.service.type.update;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOfflineStatNoticeEvent;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOfflineStatNoticeEventUpdateOperationSupport extends AbstractCampaignUpdateOperationSupport<CampaignWithOfflineStatNoticeEvent> {

    @Override
    public Class<CampaignWithOfflineStatNoticeEvent> getTypeClass() {
        return CampaignWithOfflineStatNoticeEvent.class;
    }

    @Override
    public void onChangesApplied(RestrictedCampaignsUpdateOperationContainer container,
                                 List<AppliedChanges<CampaignWithOfflineStatNoticeEvent>> appliedChanges) {
        // проставляем дефолтные значения
        appliedChanges.forEach(changes -> CampaignConverter.modifyFieldIfNull(changes,
                CampaignWithOfflineStatNoticeEvent.ENABLE_OFFLINE_STAT_NOTICE,
                CampaignConstants.DEFAULT_ENABLE_OFFLINE_STAT_NOTICE));
    }

}
